﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragment : BasePage
{
    protected readonly string patientWorkflowsPage = "PatientWorkflows.aspx?patientId=";
    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();

        if (!IsPostBack)
        {
            string patientId = string.Empty;

            HiddenFieldPatientID.Value = GetQueryStringValue();// Request["patientId"].ToString();
            LinkButtonAddLab.PostBackUrl = string.Format("DoDFragmentLab.aspx?patientId={0}",
                                                          HiddenFieldPatientID.Value);
            DisplayPatientInfo();
        }
    }

    private string GetQueryStringValue()
    {        
        string patientId = string.Empty;
        try
        {
            if (IsQueryStringValid())
            {
                patientId = Request.QueryString["patientId"].ToString();
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error parsing request data.");            
        }        
        return patientId;   
    }

    private bool IsQueryStringValid()
    { 
        bool isQuesryStringValid = false;
        if (Request.QueryString["patientId"] != null)
	    {              
              if (Regex.IsMatch(Request.QueryString["patientId"].ToString(), "^[a-zA-Z0-9]*$"))
              {
                  isQuesryStringValid = true;            
              }		 
	    }    
        return isQuesryStringValid;    
    }


    private void DisplayPatientInfo()
    {
        if (!string.IsNullOrEmpty(AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"],false)))
        {
            int patientId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"],false));
            PatientManager patientManager = new PatientManager();
            PATIENT patient = patientManager.SelectByPatientID(patientId);

            if (patient != null)
            {
                BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > " + patient.FullName;
                BaseControlLabelPatientFullName.Text = patient.FullName;
                BaseControlLabelPatientSnum.Text = patient.Snum;
            }
        }
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            userControl = PanelPatient.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                controls_BaseControlLabel baseControl = (controls_BaseControlLabel)userControl;
                baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                    dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
            }
        }
    }


    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        //Response.Redirect(String.Format("PatientWorkflows.aspx?patientId={0}", HiddenFieldPatientID.Value));

        try
        {
            string patientID = string.Empty;
            if (HiddenFieldPatientID != null)
	        {
                patientID = AntiXssEncoder.UrlEncode(HiddenFieldPatientID.Value);		 
	        }

            string destinationUrl = string.Concat(patientWorkflowsPage, patientID);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(destinationUrl);
                Server.Transfer(destinationUrl);
                //Response.Redirect(destinationUrl);
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in to redirect to Export page: - patient workflow page.");
        }  
    }
}
